package gov.va.med.mhv.bluebutton.bbmi.imaging.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class HTTPIO {
	private HttpURLConnection httpConn;
	
	public HTTPIO() {
	}
	
	public byte[] httpGET(String url) throws IOException {
		setupGETRequest(url, null);
		return sendGETRequest(); 
	}
	
	private void setupGETRequest(String requestURL, Map<String, String> headers) throws IOException {
		//audit.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date())+" - "+requestURL);

		URL url = new URL(requestURL);
		httpConn = (HttpURLConnection) url.openConnection();

		httpConn.setUseCaches(false);
		httpConn.setDoOutput(false); // false indicates GET method
		httpConn.setDoInput(true);
		for (String key : headers.keySet()) {
			httpConn.setRequestProperty(key, headers.get(key));
		}
		httpConn.setRequestProperty("User-Agent", "CodeJava Agent");
	}

	private byte[] sendGETRequest() throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream(8*1024);
		// checks server's status code first
		int status = httpConn.getResponseCode();
		if (status == HttpURLConnection.HTTP_OK) {
			BufferedInputStream input = new BufferedInputStream( httpConn.getInputStream() );
			byte[] bucket = new byte[32*1024];
			int bytesRead = 0;
	        while(bytesRead != -1){
	          bytesRead = input.read(bucket);
	          if(bytesRead > 0){
	            baos.write(bucket, 0, bytesRead);
	          }
	        }
		} else {
			throw new IOException("Response: " + status + " was returned by mhv");
		}
		return baos.toByteArray();
	}

}